// ---------------------------------------------------------------------------
//
//              VIDEO_TS.IFO structure (VMG, Video ManaGer IFO)
//              VTS_nn_n.IFO structure (VTS, Video Title-Set IFO)
//
//              (P)2007 - FSL FreeSoftLand - http://fsl.sytes.net
//
// ---------------------------------------------------------------------------

unit Structure_IFO;

interface

uses
  Structure_Common;

// ---------------------------------------------------------------------------
//                           VMG, Video ManaGer:
//
// VIDEO_TS.IFO + VIDEO_TS.VOB + VIDEO_TS.BUP
//            |                             |
//            '-Last_Sector_of_VTSI         '-Last_Sector_of_VTS
//
// ---------------------------------------------------------------------------
//
// VIDEO_TS.IFO sections:
//
// VMGI_MAT:        Requested - Video ManaGer Information MAnagement Table
// VMGM_VOB:        Requested - Video ManaGer Menu VideoOBject-Set
// FP_PGC:          Requested - First Play ProGram Chain
// VMG_PTT_SRPTI:   Requested - Video ManaGer Part of TiTle SeaRch Pointer Table Information
// VMGM_PGCI_UT:    Optional  - Video ManaGer Menu ProGram Chain Index Unit Table
// VMG_PTL_MAIT:    Optional  - Video ManaGer ParenTaL MAnagement Information Table
// VMG_VTS_ATRT:    Requested - Video ManaGer Video Title Set ATtRibute Table
// VMG_TXTDT_MGI:   Optional  - Video ManaGer TeXT DaTa ManaGer Information
// VMGM_C_ADT:      Requested - Video ManaGer Menu Cell ADdress Table information
// VMGM_VOBU_ADMAP: Requested - Video ManaGer Menu VOBU ADdress MAP table
//----------------------------------------------------------------------------

type VMG = record
  // --------------------------------------
  // OFFSET 0, begin of VIDEO_TS.IFO file
  // --------------------------------------

  // [Byte offset: 0]                Video ManaGer inforMation MAnagement Table

  VMGI_MAT: record
    Identifier:                      Array[0..11] of Char;                    // [  0- 11] VMG identifier = "DVDVIDEO-VMG"
    Last_Sector_of_VMG:              LongWord;                                // [ 12- 15] Last sector of VMG (Last sector of  VIDEO_TS.BUP)
    Unused_001:                      Array[0..11] of Byte;                    // [ 16- 27] PADDING BYTES (11)
    Last_Sector_of_VMGI:             LongWord;                                // [ 28- 31] Last sector of VMGI (Last sector of  VIDEO_TS.IFO)
    Specification_version_number:    Version_number;                          // [ 32- 33] Specification version number
    Category:                        VMG_Category;                            // [ 34- 37] VMG Category
    Number_of_Volumes:               Word;                                    // [ 38- 39] VMG Number of Volumes
    This_Volume:                     Word;                                    // [ 40- 41] VMG This Volume
    Disc_side:                       Byte;                                    // [ 42- 42] Disc side
    Unused_002:                      Array[0..18] of Byte;                    // [ 43- 61] PADDING BYTES (19)
    Number_of_Title_Sets:            Word;                                    // [ 62- 63] VMG Number of Title Sets
    Provider_ID:                     Array[0..31] of Char;                    // [ 64- 95] Provider ID
    POS_Code:                        Array[0..7] of Byte;                     // [ 96-103] VMG POS Code
    Unused_003:                      Array[0..23] of Byte;                    // [104-127] PADDING BYTES (23) (fill to 128)

    // [Byte offset: 128]

    End_byte_of_VMGI_MAT:            LongWord;                                // [128-131] End byte of VMGI_MAT
    First_Play_PGC_start_byte:       LongWord;                                // [132-135] Start address of FP_PGC
    Unused_004:                      Array[0..55] of Byte;                    // [136-191] PADDING BYTES (56)
    Start_sector_of_VMGM_VOBS:       LongWord;                                // [192-195] Menu VOB
    Start_sector_of_VMG_TT_SRPT:     LongWord;                                // [196-199] Table of Titles
    Start_sector_of_VMGM_PGCI_UT:    LongWord;                                // [200-203] Menu Program Chain Table
    Start_sector_of_VMG_PTL_MAIT:    LongWord;                                // [204-207] Parental Management Masks
    Start_sector_of_VMG_VTS_ATRT:    LongWord;                                // [208-211] VTS audio/sub-picture attributes
    Start_sector_of_VMG_TXTDT_MG:    LongWord;                                // [212-215] Text data
    Start_sector_of_VMGM_C_ADT:      LongWord;                                // [216-219] Menu cell address table
    Start_sector_of_VMGM_VOBU_ADMAP: LongWord;                                // [220-223] Menu VOBU address map
    Unused_005:                      Array[0..31] of Byte;                    // [234-255] PADDING BYTES (32) (fill to 256)
  end;

  // [Byte offset: 256]              Video ManaGer Menu VideoOBject-Set

  VMGM_VOBS:                         Menu_VOB;                                // [256-257] Video attributes of VMGM_VOBS
                                                                              // [258-259] Number of audio streams in VMGM_VOBS
                                                                              // [260-323] VMGM audio (8) attributes list
                                                                              // [324-340] PADDING BYTES (16)
                                                                              // [341-341] Number of Sub-picture streams in VMGM
                                                                              // [342-347] VMGM sub-picture (1) attributes
                                                                              // [348-511] PADDING BYTES (164) (fill to 512)

  // [Byte offset: 512]              half KByte, empty

  Unused_001:                        Array[0..511] of Byte;                   // [512-1023] PADDING BYTES (1024) (fill to 2048, 1 sector)

  // [Byte offset: 1024 (First Play PGC start byte)]    First Play PGC

  First_Play_PGC:                    PGC;                                     // [1024] present if First_Play_PGC_start_byte <> 0

  Unused_002:                        Array of Byte;                           // [????-2047] PADDING BYTES (fill to 2048, 1 sector)

  // -----------------------------------------------------------
  // 2048 bytes OFFSET (1 sector) from VIDEO_TS.IFO file begin
  // -----------------------------------------------------------

  // [Start_sector_of_VMG_TT_SRPT]   Video ManaGer Part of TiTle SeaRch Pointer Table Information

  VMG_TT_SRPT: record
    Number_of_Tile_PlayMaps:         Word;                                    // Number of Title Unit Search Pointers TTUs in the VMG
    Unused:                          Word;                                    // PADDING BYTES (2)
    End_byte_of_TT_SRPT:             LongWord;                                // End byte of TT_SRPT table (length of table - 1)
    TT_array:                        array of TT;                             // TT_array[n]: TiTle PlayMaps
  end;

  // [Start sector of VMGM_PGCI_UT]  Video ManaGer Menu ProGram Chain Index Unit Table (optional)

  VMGM_PGCI_UT: record
    Number_of_PGCI_LUs:              Word;                                    // Number of VMGM_PGCI_LUs
    Unused:                          Word;                                    // PADDING BYTES (2)
    End_byte_of_PGCI_LUs:            LongWord;                                // End byte of VMGM_PGCI_LUs table (length of table - 1)
    PGCI_LUI_array:                  array of PGCI_LUI;                       // Starting records for PGCI_LU_array[n]
    PGCI_LU_array:                   array of PGCI_LU;                        // PGCI_LU_array[n]: Video Title Set Menu Language Unit
  end;

  // [Start sector of VMG_PTL_MAIT]  Video ManaGer ParenTaL MAnagement Information Table (optional)

  VMG_PTL_MAIT: record
    Number_of_countries:             Word;                                    // Number of countries
    Number_of_TitleSet_to_manage:    Word;                                    // Number of title sets to manage (NTS)
    End_byte_of_table:               LongWord;                                // End byte of table (length of table - 1)
    Country_Codes_array:             array of Country_Codes;                  // Starting records for PTL_MAIT_array[n] (Country codes table index)
    PTL_MAIT_array:                  array of array[0..7] of array of Word;   // [Countries][8..1][VMG + all Title-Sets] of 16-bit masks
  end;

  // [Start sector of VMG_VTS_ATRT]  Video ManaGer Video Title Set ATtRibute Table

  VMG_VTS_ATRT: record
    Number_of_ATRT:                  Word;                                    // Number of ATtRibute Tables (of Title Sets)
    Unused:                          Word;                                    // PADDING BYTES (2)
    End_byte_of_table:               LongWord;                                // End byte of table (length of table - 1)
    ATRT_start_byte_array:           array of LongWord;                       // Starting pointers for ATRT_array[n] (ATtRibute Tables)
    ATRT_array:                      array of ATRT;                           // ATtRibute Tables ($308 bytes fixed length for each table item)
  end;

  // [Start sector of VMG_TXTDT_MGI] Video ManaGer TeXT DaTa ManaGer Information (Opzionale)

  VMG_TXTDT_MG: record                                                        // TeXT DaTa ManaGer record:
    Company_Identifier:              Array[0..14] of Char;                    // Company Identifier
    Number_of_TXTDT_LUs:             byte;                                    // Number of Language Units in TXTDT_MG
    End_byte_of_table:               LongWord;                                // End byte of table (length of table - 1)
    TXTDT_LUI_array:                 array of TXTDT_LUI;                      // Starting records for TXTDT_LU_array[n]
    TXTDT_LU_array:                  array of TXTDT_LU;                       // TXTDT_LU_array[n]: TeXT DaTa Language Unit
  end;

  // [Start sector of VMGM_C_ADT]    Video ManaGer Menu Cell ADdress Table information

  VMGM_C_ADT:                        C_ADT;                                   // Number of VOB cells
                                                                              // PADDING BYTES (2)
                                                                              // End byte of table
                                                                              // C_AD_array[n]: Cel address tables

  // [Start sector of VMGM_VOBU_ADMAP] Video ManaGer Menu VOBU ADdress MAP table

  VMGM_VOBU_ADMAP:                   VOBU_ADMAP;                              // End byte of VMGM_VOBU_ADMAP table
                                                                              // VOBU_start_sector_array[n]: Array of VOBU[n] start sector

  // Structure reading data diagnostic (outside IFO structure)

  Diagnostic: record
    EndByte_VMG_TT_SRPT:             Boolean;                                 // True if VMG_PTT_SRPT end byte match.
    EndByte_VMGM_PGCI_UT:            Boolean;                                 // True if VMGM_PGCI_UT end byte match.
    EndByte_VMG_PTL_MAIT:            Boolean;                                 // True if VMG_PTL_MAIT end byte match.
    EndByte_VMG_VTS_ATRT:            Boolean;                                 // True if VMG_VTS_ATRT end byte match.
    EndByte_VMG_TXTDT_MG:            Boolean;                                 // True if VMG_TXTDT_MG end byte match.
    EndByte_VMGM_C_ADT:              Boolean;                                 // True if VMGM_C_ADT end byte match.
    EndByte_VMGM_VOBU_ADMAP:         Boolean;                                 // True if VMGM_VOBU_ADMAP end byte match.
    Dummy:                           LongWord;
  end;
end;


// ---------------------------------------------------------------------------
//                           VTS, Video Title-Set:
//
// VTS_XX_0.IFO + VTS_XX_0.VOB + VTS_XX_1.VOB..VTS_XX_9.VOB + VTS_XX_0.BUP
//            |                                                          |
//            '-Last_Sector_of_VTSI                                      '-Last_Sector_of_VTS
//
// ---------------------------------------------------------------------------
//
// VTS_XX_X.IFO, composto da:
//
// VTSI_MAT:        Requested - Video Title Set Information MAnagement Table
// VTSM_VOB:        Requested - Video Title Set Menu VideoOBject set
// VTS_VOB:         Requested - Video Title Set VideoOBject set
// VTS_PTT_SRPTI:   Requested - Part of TiTle SeaRch Pointer Table Index
// VTS_PGCITI:      Optional  - Video Title Set ProGram Chain Information Table Index
// VTSM_PGCI_UT:    LU opt. -   Video Title Set Menu PGCI Unit Table
// VTS_TMAPTI:      Requested - Video Title Set Time MAP Table Index
// VTSM_C_ADT:      Requested - Video Title Set Menu Cell ADdress Table
// VTSM_VOBU_ADMAP: Requested - Video Title Set Menu VOBU ADdress MAP table
// VTS_C_ADT:       Requested - Video Title Set Cell ADdress Table
// VTS_VOBU_ADMAP:  Requested - Video Title Set menu VOBU ADdress MAP table
//----------------------------------------------------------------------------

type VTS = record
  // --------------------------------------
  // Offset 0, Vts_nn_n.Ifo file begin
  // --------------------------------------

  // [Byte Offset: 0]                Video Title-Set Information Management Table

  Vtsi_mat: Record
    Identifier:                      Array[0..11] Of Char;                    // [  0- 11] Vts identifier "Dvdvideo-Vts"
    Last_sector_of_vts:              Longword;                                // [ 12- 15] Last Sector Of Vts
    Unused_001:                      Array[0..11] Of Byte;                    // [ 16- 27] Padding Bytes (12)
    Last_sector_of_vtsi:             Longword;                                // [ 28- 31] Last Sector Of Vtsi (Of This File)
    Specification_version_number:    Version_number;                          // [ 32- 33] Specification Version Number
    Category:                        Longword;                                // [ 34- 37] Vts Category 0=Unspecified, 1=Karaoke
    Unused_002:                      Array[0..89] Of Byte;                    // [ 38-127] Padding Bytes (90) (fill to 128)

    // [Byte Offset: 128]

    End_byte_of_vtsi_mat:            Longword;                                // [128-131] End Byte Of Vtsi_mat
    Unused_003:                      Array[0..59] Of Byte;                    // [132-191] Padding Bytes (60)
    Start_sector_of_vtsm_vobs:       Longword;                                // [192-195] Vts Menu Videoobject Set
    Start_sector_of_vtstt_vobs:      Longword;                                // [196-199] Vts Videoobject Set
    Start_sector_of_vts_ptt_srpt:    Longword;                                // [200-203] Part Of Title Search Pointer Table Index
    Start_sector_of_vts_pgcit:       Longword;                                // [204-207] Vts Program Chain Information Table Index
    Start_sector_of_vtsm_pgci_ut:    Longword;                                // [208-211] Vts Menu Pgci Unit Table
    Start_sector_of_vts_tmapt:       Longword;                                // [212-215] Vts Menu Language Unit Table Index
    Start_sector_of_vtsm_c_adt:      Longword;                                // [216-219] Vts Menu Cell Address Table
    Start_sector_of_vtsm_vobu_admap: Longword;                                // [220-223] Vts Menu Vobu Address Map Table
    Start_sector_of_vts_c_adt:       Longword;                                // [224-227] Vts Cell Address Table
    Start_sector_of_vts_vobu_admap:  Longword;                                // [228-231] Vts Menu Vobu Address Map Table
    Unused_004:                      Array[0..23] Of Byte;                    // [232-255] Padding Bytes (24) (fill to 256)
  End;

  // [Byte Offset: 256]              Video Title Set Menu Videoobject Set

  Vtsm_vob:                          Menu_vob;                                // [256-257] Video Attributes Of Vtsm_vobs
                                                                              // [258-259] Number Of Audio Streams In Vtsm_vobs
                                                                              // [260-323] Vtsm Audio (8) Attributes List
                                                                              // [324-340] Padding Bytes (16)
                                                                              // [341-341] Number Of Sub-Picture Streams In Vtsm
                                                                              // [342-347] Vtsm Sub-Picture (1) Attributes
                                                                              // [348-511] Padding Bytes (164) (Fill to 256)

  // [Byte Offset: 512]              Video Title Set Videoobject Set

  Vts_vob:                           Title_vob;                               // [512-513] Video Attributes Of Vtstt_vobs
                                                                              // [514-515] Number Of Audio Streams In Vtstt_vobs
                                                                              // [516-579] Audio (8) Attributes List
                                                                              // [580-595] Padding Bytes (16)
                                                                              // [596-597] Number Of Sub-Picture Streams In Vtstt_vobs
                                                                              // [598-789] Sub-Picture Stream (32) Attributes List
                                                                              // [790-791] Padding Bytes (2)
                                                                              // [792-983] Multichannel Extension (24)
                                                                              // [984-1023] Padding Bytes (40) (fill to 512 ($200))

  // [Byte Offset: 1024]             Half KByte, empty

  Unused:                            Array[0..1023] Of Byte;                  // [1024-2047] Padding Bytes (1024) (fill to 2048, 1 Sector)

  // ------------------------------------------------------------
  // 2048 bytes OFFSET (1 sector) from Vts_nn_n.Ifo file begin
  // ------------------------------------------------------------

  // [Start Sector Of Vts_ptt_srpt] Part Of Title Search Pointer Table Index (Titleset/Chapter table)

  Vts_ptt_srpti: Record
    Title_unit_search_pointers:      Word;                                    // Number Of Title Unit Search Pointers Ttus In The Vts
    Unused:                          Word;                                    //
    End_byte_of_ptt_srpt:            Longword;                                // End Byte Of Ptt_srpt Table
    Ttu_array:                       Array Of Longword;                       // Starting Records For Ptt[N]
    Ptt_array:                       Array Of Array Of Ptt;                   // Ptt[N,N] Table
  End;

  // [Start Sector Of Vts_pgciti]    Video Title Set Program Chain Information Table Index

  Vts_pgciti: Record
    Number_of_program_chains:        Word;                                    // Number Of Vts_pgci_srp
    Unused:                          Word;                                    //
    End_byte_of_program_chains:      Longword;                                // End Byte Of Vts_pgci Table
    Pgci_array:                      Array Of Pgci;                           // Starting Pointers For Pgc_array[N]
    Pgc_array:                       Array Of Pgc;                            // Pgc_array[N]: Program Chain
  End;

  // [Start Sector Of Vtsm_pgci_ut]  Video Title Set Menu Pgci Unit Table

  Vtsm_pgci_ut: Record
    Number_of_pgci_lus:              Word;                                    // Number Of Vtsm_pgci_lus
    Unused:                          Word;                                    //
    End_byte_of_pgci_lus:            Longword;                                // End Byte Of Vtsm_pgci_lus Table
    Pgci_lui_array:                  Array Of Pgci_lui;                       // Starting Records For Lu_array[N]
    Pgci_lu_array:                   Array Of Pgci_lu;                        // Lu_array[N]: Language Unit
  End;

  // [Start Sector Of Vts_tmapti]    Video Title Set Time Map Table Index

  Vts_tmapti: Record
    Number_of_tmaps:                 Word;                                    // Number Of Vts_tmaps
    Unused:                          Word;                                    //
    End_byte_of_tmaps:               Longword;                                // End Byte Of Vts_tmaps Table
    Tmap_start_byte_array:           Array Of Longword;                       // Starting Pointers For Tmap_array[N]
    Tmap_array:                      Array Of Tmap;                           // Tmap_array[N]: Vts_map Time Maps
  End;

  // [Start Sector Of Vtsm_c_adt]    Video Title Set Menu Cell Address Table

  Vtsm_c_adt:                        C_adt;                                   // Number Of Vob Cells
                                                                              // Padding Bytes (2)
                                                                              // End Byte Of Table
                                                                              // C_ad_array[N]: Cel Address Tables

  // [Start Sector Of Vtsm_vobu_admap]  Video Title Set Menu Vobu Address Map Table

  Vtsm_vobu_admap:                   Vobu_admap;                              // End Byte Of Vtsm_vobu_admap Table
                                                                              // Vobu_start_sector_array[N]: Array Of Vobu[N] Start Sector

  // [Start Sector Of Vts_c_adt]     Video Title Set Cell Address Table

  Vts_c_adt:                         C_adt;                                   // Number Of Vob Cells
                                                                              // Padding Bytes (2)
                                                                              // End Byte Of Table
                                                                              // C_ad_array[N]: Cel Address Tables

  // [Start Sector Of Vts_vobu_admap]  Video Title Set Menu Vobu Address Map Table

  Vts_vobu_admap:                    Vobu_admap;                              // End Byte Of Vts_vobu_admap Table
                                                                              // Vobu_start_sector_array[N]: Array Of Vobu[N] Start Sector

  // ------------------------------------------------------------------------
  // Fine Vts_nn_n.Ifo
  // ------------------------------------------------------------------------

  // Structure reading data diagnostic (outside IFO structure)

  Diagnostic: Record
    Endbyte_vts_ptt_srpt:            Boolean;                                 // True if Vts_ptt_srpt end byte match.
    Endbyte_vts_pgcit:               Boolean;                                 // True if Vts_pgcit end byte match.
    Endbyte_vtsm_pgci_ut:            Boolean;                                 // True if Vtsm_pgci_ut end byte match.
    Endbyte_vts_tmapt:               Boolean;                                 // True if Vts_tmapt end byte match.
    Endbyte_vtsm_c_adt:              Boolean;                                 // True if Vtsm_c_adt end byte match.
    Endbyte_vtsm_vobu_admap:         Boolean;                                 // True if Vtsm_vobu_admap end byte match.
    Endbyte_vts_c_adt:               Boolean;                                 // True if Vts_c_adt end byte match.
    Endbyte_vts_vobu_admap:          Boolean;                                 // True if Vts_vobu_admap end byte match.
    Dummy:                           Longword;
  End;
end;


// --------------------------------------------------------------------------
// Used to identify IFO file type
// --------------------------------------------------------------------------

type IfoFileType = (tIfoVMG, tIfoVTS, tIfoUnknown);


implementation

end.
